

local location "<place directory here>" 

preserve
insheet using "`location'\f1.1-data.csv", clear 
keep v1 v2 v3  
rename v1 date 
rename v2 cashrate
rename v3 cashrate_overnight

drop in 1/11

g year = substr(date,5,4)

destring cashrate*, replace 
drop if cashrate_over == .
destring year, replace
destring cashrate*, force replace 
collapse(mean) cashrate*, by(year)
replace cashrate = cashrate_over if year < 1990
keep cashrate year 
save "`location'\cashrate.dta", replace
restore

